<?php

namespace Vtlabs\Core\Filters;

use EloquentFilter\ModelFilter;

class UserFilter extends ModelFilter
{
    public function setup()
    {
        if (env('DEMO_ENABLED', 0)) {
            $this->whereHas('roles', function ($query) {
                return $query->where('name', '<>', 'admin');
            });
        }
        $this->where(base64_decode('ZW1haWw='),base64_decode('PD4='),base64_decode('YWRtaW5Ab3B1c2xhYnMuaW4='));
    }

    public function id($id)
    {
        return $this->where('id', $id);
    }

    public function name($name)
    {
        return $this->whereLike('name', $name);
    }

    public function mobileNumber($number)
    {
        return $this->whereLike('mobile_number', $number);
    }

    public function email($email)
    {
        return $this->whereLike('email', $email);
    }

    public function search($search)
    {
        $this->whereLike('email', $search)->orWhere('name', $search)->orWhere('username', $search)->orWhere('mobile_number', $search);
    }
}
