<?php

namespace Vtlabs\Category\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Vtlabs\Core\Http\Resources\UserSummaryResource;

class CategoryResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'slug' => $this->slug,
            'title' => $this->title,
            'title_translations' => $this->getTranslations('title'),
            'meta' => $this->meta,
            'is_global' => $this->is_global,
            'private_posts' => $this->private_posts,
            'sort_order' => $this->sort_order,
            'max_duration' => $this->max_duration,
            'mediaurls' => $this->getMediaUrlsAttribute(),
            'parent_id' => $this->parent_id,
            'admin_id' => $this->admin_id,
            'admin' => new UserSummaryResource($this->admin)
        ];
    }
}