<?php

namespace Vtlabs\Category\Filters;

use EloquentFilter\ModelFilter;
use Illuminate\Support\Facades\App;
use Vtlabs\Core\Helpers\CoreHelper;
use Vtlabs\Core\Services\UserService;

class CategoryFilter extends ModelFilter
{
    public function setup()
    {
        if ($this->input('_sort') && $this->input('_order')) {
            $sortColumn = $this->input('_sort');
            $sortOrder = $this->input('_order');
            if(in_array($sortColumn, ['id', 'slug','sort_order'])) {
                $this->orderBy($sortColumn, $sortOrder);
            } else {
                $this->ordered();
            }
        } else {
            $this->ordered();
        }
    }

    public function id($id)
    {
        return $this->where('id', $id);
    }

    public function slug($slug)
    {
        return $this->where('slug', 'like', '%' . $slug . '%');
    }

    public function title($title)
    {
        return CoreHelper::searchTranslated($this, 'title', App::getLocale(), $title);
    }

    public function category($id)
    {
        return $this->related('category', 'id', '=', $id);
    }

    public function parent()
    {
        return $this->doesntHave('category');
    }

    public function subcategories()
    {
        return $this->has('category');
    }

    public function scope($scope)
    {
        return $this->where('meta->scope', $scope);
    }

    public function meta($meta)
    {
        return $this->where('meta->scope', 'like', '%' . $meta . '%');
    }

    public function categories($categories)
    {
        $categories = explode(',', $categories);

        return $this->whereHas('category', function($query) use ($categories) {
            return $query->whereIn('id', $categories);
        });
    }

    public function global($global)
    {
        return $this->where('is_global', 1);
    }

    public function postalCode($postalCode)
    {
        $admin = UserService::postalcodeToAdmin($postalCode);
        if($admin) {
            return $this->where('admin_id', $admin->id);
        }
    }

    public function admin($admin)
    {
        return $this->where('admin_id', $admin);
    }
}
