<?php

namespace Vtlabs\Carrental\Providers;

use Vtlabs\Core\Events\LoggedIn;
use Vtlabs\Core\Events\RoleAssigned;
use Vtlabs\Payment\Events\OnWalletPayment;
use Vtlabs\Carrental\Listeners\LoggedInListener;
use Vtlabs\Carrental\Listeners\RoleAssignedListener;
use Vtlabs\Carrental\Listeners\OnWalletPaymentListener;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        LoggedIn::class => [LoggedInListener::class],
        RoleAssigned::class => [RoleAssignedListener::class],
        OnWalletPayment::class => [OnWalletPaymentListener::class]
    ];

    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot()
    {
        parent::boot();

        //
    }
}
