<?php

namespace Vtlabs\Carrental\Models;

use EloquentFilter\Filterable;
use Vtlabs\Core\Models\User\User;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;

class Provider extends Model
{
    use Filterable, HasTranslations;

    protected $table = 'carrental_providers';

    protected $guarded = [];

    protected $casts = [
        'name' => 'array',
        'details' => 'array',
        'meta' => 'json',
        'longitude' => 'float',
        'latitude' => 'float',
        'fee' => 'float'
    ];

    public $translatable = ['name', 'details'];

    public static function findByUser($userId)
    {
        return Provider::where('user_id', $userId)->firstOrFail();
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
