<?php

namespace Vtlabs\Carrental\Models;

use EloquentFilter\Filterable;
use Spatie\MediaLibrary\HasMedia;
use Vtlabs\Carrental\Models\Addon;
use Vtlabs\Carrental\Models\Carfee;
use Vtlabs\Category\Models\Category;
use Vtlabs\Carrental\Models\Provider;
use Rennokki\Rating\Traits\CanBeRated;
use Illuminate\Database\Eloquent\Model;
use Rennokki\Rating\Contracts\Rateable;
use Spatie\Translatable\HasTranslations;
use Vtlabs\Core\Traits\CoreHasMediaTrait;
use Vtlabs\Appointment\Contracts\Appointee;
use Vtlabs\Appointment\Traits\CanBeAppointed;
use ChristianKuri\LaravelFavorite\Traits\Favoriteable;

class Car extends Model implements Appointee, Rateable, HasMedia
{
    use Filterable,
        HasTranslations,
        Favoriteable,
        CoreHasMediaTrait,
        CanBeAppointed,
        CanBeRated;

    protected $table = 'carrental_cars';

    protected $guarded = [];

    protected $casts = [
        'name' => 'array',
        'details' => 'array',
        'meta' => 'json',
        'longitude' => 'float',
        'latitude' => 'float',
        'is_booked' => 'integer'
    ];

    public $translatable = ['name', 'details'];

    public function provider()
    {
        return $this->belongsTo(Provider::class);
    }

    public function brand()
    {
        return $this->belongsTo(Category::class);
    }

    public function fueltype()
    {
        return $this->belongsTo(Category::class);
    }

    public function type()
    {
        return $this->belongsTo(Category::class);
    }

    public function features()
    {
        return $this->belongsToMany(Category::class, 'carrental_cars_features', 'car_id', 'category_id');
    }

    public function addons()
    {
        return $this->hasMany(Addon::class, 'car_id');
    }

    public function fee()
    {
        return $this->hasMany(Carfee::class, 'car_id');
    }

    public function schedule()
    {
        return $this->hasMany(Schedule::class, 'car_id');
    }
}
