<?php

namespace Vtlabs\Carrental\Listeners;

use Vtlabs\Core\Events\RoleAssigned;
use Vtlabs\Carrental\Models\Provider;

class RoleAssignedListener
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  RoleAssigned $event
     * @return void
     */
    public function handle(RoleAssigned $event)
    {
        if (in_array('carprovider', $event->roles) || (in_array('customer', $event->roles) && config('vtlabs_carrental.register_user_as_provider'))) {
            if (!Provider::where('user_id', $event->user->id)->exists()) {
                Provider::create([
                    'name' => $event->user->name,
                    'user_id' => $event->user->id
                ]);
            }
        }

        return true;
    }
}
