<?php

namespace Vtlabs\Carrental\Listeners;

use Carbon\Carbon;
use Vtlabs\Carrental\Models\Car;
use Vtlabs\Core\Models\User\User;
use Vtlabs\Appointment\Models\Appointment;
use Vtlabs\Payment\Events\OnWalletPayment;

class OnWalletPaymentListener
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  OnWalletPayment $event
     * @return void
     */
    public function handle(OnWalletPayment $event)
    {
        $payment = $event->payment;

        if ($payment->payable_type == 'Vtlabs\Appointment\Models\Appointment' && $payment->status == 'paid') {
            $appointment = Appointment::find($payment->payable_id);

            if ($appointment->appointee_type == Car::class) {
                $user = User::find($payment->payer_id);

                // calcuate duration in hours
                $from = Carbon::createFromFormat("Y-m-d H:i:s", $appointment->date . ' ' . $appointment->time_from);
                $to = Carbon::createFromFormat("Y-m-d H:i:s", $appointment->date_to . ' ' . $appointment->time_to);

                // car image
                $carImageUrl = isset($appointment->appointee->media[0]) ? $appointment->appointee->media[0]->getFullUrl() : '';

                $user->withdraw($payment->amount, 'withdraw', [
                    'description' => 'Paid for Booking #' . $appointment->id,
                    'type' => 'wallet_payment',
                    'source_title' => $appointment->appointee->name,
                    'source_image' => $carImageUrl,
                    'source_duration_in_hours' => $from->diffInHours($to),
                    'source' => 'apopointment',
                    'source_id' => $appointment->id,
                    'source_amount' => $payment->amount,
                    'source_payment_type' => $payment->paymentMethod->type == 'postpaid' ? 'COD' : 'Online'
                ]);
            }
        }
    }
}
