<?php

namespace Vtlabs\Carrental\Listeners;

use Vtlabs\Core\Events\LoggedIn;
use Vtlabs\Core\Events\RoleAssigned;

class LoggedInListener
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  LoggedIn $event
     * @return void
     */
    public function handle(LoggedIn $event)
    {
        if($event->role == 'carprovider') {
            if(!$event->user->hasRole($event->role)) {
                // attach role
                $event->user->assignRole($event->role);
                event(new RoleAssigned($event->user, [$event->role]));
            }
        }

        if($event->role == 'customer') {
            if(config('vtlabs_carrental.register_user_as_provider') && !$event->user->hasRole('carprovider')) {
                // attach role
                $event->user->assignRole('carprovider');
                event(new RoleAssigned($event->user, ['carprovider']));
            }
        }

        return true;
    }
}
