<?php

namespace Vtlabs\Carrental\Http\Resources;

use Vtlabs\Core\Models\User\User;
use Vtlabs\Carrental\Models\Provider;
use Illuminate\Http\Resources\Json\JsonResource;
use Vtlabs\Carrental\Http\Resources\AddonResource;
use Vtlabs\Category\Http\Resources\CategoryResource;
use Vtlabs\Carrental\Http\Resources\ProviderResource;

class CarResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'name_translations' => $this->getTranslations('name'),
            'details' => $this->title,
            'details_translations' => $this->getTranslations('details'),
            'address' => $this->address,
            'longitude' => $this->longitude,
            'latitude' => $this->latitude,
            // 'fee' => $this->fee,
            'is_booked' => $this->is_booked,
            'provider_id' => $this->provider_id,
            'provider' => new ProviderResource(Provider::find($this->provider_id)),
            'brand_id' => $this->brand_id,
            'brand' => new CategoryResource($this->brand),
            'fueltype_id' => $this->fueltype_id,
            'fueltype' => new CategoryResource($this->fueltype),
            'type_id' => $this->type_id,
            'type' => new CategoryResource($this->type),
            'features' => CategoryResource::collection($this->features),
            'addons' => AddonResource::collection($this->addons),
            'fee' => CarfeeResource::collection($this->fee),
            'ratings' => $this->averageRating(User::class),
            'ratings_count' => $this->raters(User::class)->count(),
            'favourite_count' => $this->favoritesCount,
            'is_favourite' => $this->isFavourite,
            'meta' => $this->meta,
            'mediaurls' => $this->getMediaUrlsAttribute(),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at
        ];
    }
}
