<?php

namespace Vtlabs\Carrental\Http\Resources;

use Vtlabs\Carrental\Models\Car;
use Vtlabs\Core\Http\Resources\UserResource;
use Illuminate\Http\Resources\Json\JsonResource;
use Vtlabs\Carrental\Http\Resources\CarResource;
use Vtlabs\Carpro\Http\Resources\CarProfileResource;

class CarRatingResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'rating' => $this->pivot->rating,
            'review' => $this->pivot->review,
            'created_at' => $this->pivot->created_at,
            'user' => new UserResource($this->resource),
            'car' => new CarResource(Car::find($this->pivot->rateable_id))
        ];
    }
}