<?php

namespace Vtlabs\Carrental\Http\Resources;

use Vtlabs\Carrental\Models\Car;
use Vtlabs\Core\Models\User\User;
use Vtlabs\Core\Http\Resources\UserResource;
use Illuminate\Http\Resources\Json\JsonResource;
use Vtlabs\Payment\Http\Resources\PaymentResource;

class AppointmentResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'meta' => $this->meta,
            'amount' => $this->amount,
            'amount_meta' => $this->amount_meta,
            'address' => $this->address,
            'address_meta' => $this->address_meta,
            'longitude' => $this->longitude,
            'latitude' => $this->latitude,
            'date' => $this->date,
            'date_to' => $this->date_to,
            'time_from' => $this->time_from,
            'time_to' => $this->time_to,
            'status' => $this->status,
            'statuses' => $this->statuses,
            'user' => new UserResource(User::find($this->appointer_id)),
            'car' => new CarResource(Car::find($this->appointee_id)),
            'payment' => new PaymentResource($this->payment),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at
        ];
    }
}