<?php

namespace Vtlabs\Carrental\Http\Controllers\Api;

use Illuminate\Http\Request;
use Vtlabs\Core\Helpers\CoreHelper;
use Illuminate\Support\Facades\Auth;
use Vtlabs\Carrental\Models\Provider;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Carrental\Http\Resources\ProviderResource;

class ProviderController extends Controller
{
    public function show(Provider $provider)
    {
        return new ProviderResource($provider);
    }

    public function showMyProfile(Request $request)
    {
        $provider = Provider::findByUser(Auth::user()->id);
        return new ProviderResource($provider);
    }

    public function update(Request $request, Provider $provider)
    {
        $request->validate($this->rules());

        CoreHelper::requestMergeJsonField();

        $provider->fill($request->only(['meta']));

        CoreHelper::fillTranslation($provider, $request->only(['name', 'details']));

        $provider->save();

        return new ProviderResource($provider);
    }

    private function rules(): array 
    {
        return [
            'name' => 'required',
            'details' => 'required',
            'meta' => 'sometimes|json|nullable'
        ];
    }
}
