<?php

namespace Vtlabs\Carrental\Http\Controllers\Api;

use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use Vtlabs\Carrental\Models\Car;
use Illuminate\Support\Facades\Auth;
use Vtlabs\Appointment\Models\Appointment;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Carrental\Filters\AppointmentFilter;
use Vtlabs\Appointment\Services\AppointmentService;
use Vtlabs\Carrental\Http\Resources\AppointmentResource;

class AppointmentController extends Controller
{
    public function index(Request $request)
    {
        $request->validate([
            'appointer' => 'required_without:appointee|exists:users,id',
            'appointee' => 'required_without:appointer|exists:provider_profiles,id'
        ]);

        $appointments = Appointment::filter($request->all(), AppointmentFilter::class);

        if ($request->past) {
            $appointments = $appointments->orderBy('updated_at', 'desc');
        } else {
            $appointments = $appointments->orderBy('date', 'desc')->orderBy('time_from', 'desc');
        }

        return AppointmentResource::collection($appointments->paginate());
    }

    public function store(Car $car, Request $request)
    {
        $user = Auth::user();

        $request->validate(AppointmentService::validationRules());

        $appointment = $user->appoint($car, $request->all());

        //event(new NewAppointment($appointment));

        return new AppointmentResource($appointment);
    }

    public function update(Appointment $appointment, Request $request)
    {
        $request->validate([
            'status' => ['required', Rule::in(config('vtlabs_appointment.appointment.status_list'))]
        ]);

        AppointmentService::updateStatus($appointment, $request->status);

        // event(new UpdateAppointment($appointment));

        return new AppointmentResource($appointment->fresh());
    }
}
