<?php

namespace Vtlabs\Carrental\Filters;

use EloquentFilter\ModelFilter;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\App;
use Vtlabs\Core\Helpers\CoreHelper;

class CarFilter extends ModelFilter
{
    
    public function setup()
    {
        if ($this->input('long') && $this->input('lat')) {

            $distanceLimit = CoreHelper::settingsAsDictionary()['delivery_distance'] ?? 8000;
            
            $subqueryDistance = "ST_Distance_Sphere(Point(longitude,"
                . " latitude),"
                . " Point(" . $this->input('long') . ", " . $this->input('lat') . "))"
                . " as distance";

            $subqueryDistanceWhere = "ST_Distance_Sphere(Point(longitude,"
                . " latitude),"
                . " Point(" . $this->input('long') . ", " . $this->input('lat') . "))"
                . " < " . $distanceLimit;

            $this->select('*', DB::raw($subqueryDistance))
                ->whereRaw($subqueryDistanceWhere)->orderBy('distance');
        } else {
            $this->latest();
        }
    }

    public function type($id) 
    {
        return $this->where('type_id', $id);
    }

    public function fuelType($id) 
    {
        return $this->where('fueltype_id', $id);
    }

    public function brand($id) 
    {
        return $this->where('brand_id', $id);
    }

    public function priceFrom($price)
    {
        return $this->whereHas('fee', function($query) use($price) {
            return $query->where('fee', '>', $price);
        });
    }

    public function priceTo($price)
    {
        return $this->whereHas('fee', function($query) use($price) {
            return $query->where('fee', '<', $price);
        });
    }

    public function search($search)
    {
        $locale = App::getLocale();
        return CoreHelper::searchTranslated($this, 'name', $locale, $search);
    }
}
