<?php

namespace Vtlabs\Carrental\Filters;

use EloquentFilter\ModelFilter;
use Vtlabs\Carrental\Models\Car;
use Vtlabs\Core\Models\User\User;
use Vtlabs\Carrental\Models\ProviderProfile;

class AppointmentFilter extends ModelFilter
{
    public function setup()
    {
        $this->where('appointer_type', User::class)
            ->where('appointee_type', Car::class);
    }

    public function appointer($id)
    {
        return $this->where('appointer_id', $id);
    }

    public function appointee($id)
    {
        return $this->where('appointee_id', $id);
    }

    public function owner($owner)
    {
        $carIds = Car::whereHas('provider', function ($query) use ($owner) {
            return $query->Where('user_id', $owner);
        })->pluck('id')->toArray();
        return $this->whereIn('appointee_id', $carIds);
    }

    public function date_from($date_from)
    {
        return $this->where('date', '>=', $date_from);
    }

    public function date_to($date_to)
    {
        return $this->where('date', '<=', $date_to);
    }
}
