<?php
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

use Illuminate\Http\Request;

Route::middleware('api')->prefix('api')->name('api')->namespace('Vtlabs\Carrental\Http\Controllers\Api')->group(function () {

    // admin api
    Route::namespace('Admin')->name('admin')->prefix('admin/carrental')->group(function () {
        Route::middleware('auth:api')->group(function () {
            Route::apiResource('providers', 'ProviderController');
            
            Route::get('cars/{car}/schedule', 'CarController@schedule');
            Route::apiResource('cars', 'CarController');
            
            Route::apiResource('appointments', 'AppointmentController')->except(['create']);

            Route::get('/dashboard/booking-analytics', 'DashboardController@bookingAnalytics');
            Route::get('/dashboard/progress-info', 'DashboardController@progressInfo');
        });
    });

    // app/web api
    Route::prefix('carrental')->group(function () {
        
        // cars
        Route::apiResource('cars', 'CarController');

        Route::middleware('auth:api')->group(function () {
            // appointment
            Route::get('appointments', 'AppointmentController@index');
            Route::post('appointments/{car}', 'AppointmentController@store');
            Route::put('appointments/{appointment}', 'AppointmentController@update');

            Route::get('providers/my-profile', 'ProviderController@showMyProfile');
            Route::apiResource('providers', 'ProviderController')->only(['show', 'updatee']);

            Route::get('cars/ratings/{car}', 'CarController@ratingList');
            Route::post('cars/ratings/{car}', 'CarController@ratingStore');
            Route::get('cars/ratings/summary/{car}', 'CarController@ratingSummary');
        });

    });
});
