<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCarrentalSchedule extends Migration
{
    public function up()
    {
        Schema::create('carrental_schedule', function (Blueprint $table) {
            $table->increments('id');
            $table->date('date_from');
            $table->date('date_to');
            $table->enum('type', ['booked', 'off']);

            $table->integer('appoinment_id')->unsigned()->nullable();
            $table->foreign('appoinment_id')->references('id')->on('appointments')->onDelete('cascade');
            
            $table->foreignId('car_id')->nullable()->constrained('carrental_cars')->cascadeOnDelete();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
    }
}
