<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCarrentalCarsTable extends Migration
{
    public function up()
    {
        Schema::create('carrental_cars', function (Blueprint $table) {
            $table->id();
            $table->json('name')->nullable();
            $table->json('details')->nullable();
            $table->json('meta')->nullable();
            $table->string('address')->nullable();
            $table->decimal('longitude', 15, 7)->default(0.0);
            $table->decimal('latitude', 15, 7)->default(0.0);
            // $table->decimal('fee', 8, 2)->unsigned()->default(0.0);
            $table->boolean('is_booked')->default(false);
            $table->integer('provider_id')->unsigned()->nullable();
            $table->foreign('provider_id')->references('id')->on('carrental_providers')->onDelete('cascade');
            $table->integer('brand_id')->unsigned()->nullable();
            $table->foreign('brand_id')->references('id')->on('categories')->onDelete('set null');
            $table->integer('fueltype_id')->unsigned()->nullable();
            $table->foreign('fueltype_id')->references('id')->on('categories')->onDelete('set null');
            $table->integer('type_id')->unsigned()->nullable();
            $table->foreign('type_id')->references('id')->on('categories')->onDelete('set null');    
            $table->timestamps();
        });

        Schema::create('carrental_cars_features', function (Blueprint $table) {
            $table->bigInteger('car_id')->unsigned();
            $table->integer('category_id')->unsigned();
            $table->foreign('car_id')->references('id')->on('carrental_cars')->onDelete('cascade');
            $table->foreign('category_id')->references('id')->on('categories')->onDelete('cascade');
        });

        Schema::create('carrental_cars_addons', function (Blueprint $table) {
            $table->id();
            $table->decimal('fee', 8, 2)->unsigned()->default(0);
            $table->string('title')->nullable();
            $table->boolean('is_per_day')->default(false);
            $table->bigInteger('car_id')->unsigned();
            $table->foreign('car_id')->references('id')->on('carrental_cars')->onDelete('cascade');
        });

        Schema::create('carrental_cars_fee', function (Blueprint $table) {
            $table->id();
            $table->unsignedTinyInteger('days');
            $table->decimal('fee', 8, 2)->unsigned()->default(0);
            $table->bigInteger('car_id')->unsigned();
            $table->foreign('car_id')->references('id')->on('carrental_cars')->onDelete('cascade');
        });
    }
    
    /**
    * Reverse the migrations.
    *
    * @return void
    */
    public function down()
    {
        Schema::table('carrental_cars_features', function (Blueprint $table) {
            $table->dropForeign(['car_id']);
            $table->dropForeign(['category_id']);
        });
        Schema::dropIfExists('carrental_cars_features');

        Schema::table('cars', function (Blueprint $table) {
            $table->dropForeign(['user_id']);
            $table->dropForeign(['brand_id']);
            $table->dropForeign(['fueltype_id']);
            $table->dropForeign(['type_id']);
        });
        Schema::dropIfExists('carrental_cars');
    }
}
