<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCarrentalProvidersTable extends Migration
{
    public function up()
    {
        Schema::create('carrental_providers', function (Blueprint $table) {
            $table->increments('id');
            $table->json('name')->nullable();
            $table->json('details')->nullable();
            $table->json('meta')->nullable();
            $table->integer('user_id')->unsigned();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('carrental_providers', function (Blueprint $table) {
            $table->dropForeign(['user_id']);
        });
        Schema::dropIfExists('carrental_providers');
    }
}
