<?php

namespace Vtlabs\Carpool\Models;

use EloquentFilter\Filterable;
use Vtlabs\Core\Models\User\User;
use Spatie\ModelStatus\HasStatuses;
use Vtlabs\Payment\Traits\CanBePaid;
use Vtlabs\Payment\Contracts\Payable;
use Illuminate\Database\Eloquent\Model;

class CarpoolRide extends Model implements Payable
{
    use CanBePaid, HasStatuses, Filterable;

    protected $table = 'carpool_rides';

    protected $guarded = [];

    public static function boot()
    {
        parent::boot();

        // on create
        static::created(function ($order) {
            $order->setStatus(config('vtlabs_carpool.ride.status_default'));
        });
    }

    public function profile()
    {
        return $this->belongsTo(CarpoolProfile::class, 'profile_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
