<?php

namespace Vtlabs\Carpool\Http\Resources;

use Vtlabs\Core\Http\Resources\UserResource;
use Illuminate\Http\Resources\Json\JsonResource;

class CarpoolProfileSearchResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'meta' => $this->meta,
            'vehicle_details' => $this->vehicle_details,
            'seats' => $this->seats,
            'is_verified' => $this->is_verified,
            'price' => $this->price,
            'travel_days' => $this->travel_days,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'user_id' => $this->user_id,
            'user' => new UserResource($this->user),
            'pickup_location_id' => $this->pickup_location_id,
            'drop_location_id' => $this->drop_location_id,
            'address_from' => $this->address_from,
            'longitude_from' => $this->longitude_from,
            'latitude_from' => $this->latitude_from,
            'address_to' => $this->address_to,
            'longitude_to' => $this->longitude_to,
            'latitude_to' => $this->latitude_to,
            'seats_available' => $this->seats_available,
            'distance_from' => $this->distance_from,
            'distance_to' => $this->distance_to,
            'pickup_locations' => $this->locations
        ];
    }
}
