<?php

namespace Vtlabs\Carpool\Http\Resources;

use Vtlabs\Core\Http\Resources\UserResource;
use Illuminate\Http\Resources\Json\JsonResource;

class CarpoolProfileResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'meta' => $this->meta,
            'vehicle_details' => $this->vehicle_details,
            'seats' => $this->seats,
            'is_verified' => $this->is_verified,
            'price' => $this->price,
            'travel_days' => $this->travel_days,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'user_id' => $this->user_id,
            'user' => new UserResource($this->user),
            'pickup_locations' => $this->locations
        ];
    }
}
