<?php
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

use Illuminate\Http\Request;

Route::middleware('api')->prefix('api')->name('api')->namespace('Vtlabs\Carpool\Http\Controllers\Api')->group(function () {

    // admin api
    Route::namespace('Admin')->name('admin')->prefix('admin/carpool')->group(function () {
        Route::middleware('auth:api')->group(function () {
            Route::apiResource('profiles', 'CarpoolProfileController');
            Route::apiResource('rides', 'CarpoolRideController');
        });
    });

    // app/web api
    Route::prefix('carpool')->group(function () {

        Route::middleware('auth:api')->group(function () {
            Route::put('/profiles', 'CarpoolProfileController@update');
            Route::get('/profiles/my-profile', 'CarpoolProfileController@showMyProfile');

            Route::get('/rides', 'CarpoolRideController@index');
            Route::post('/rides', 'CarpoolRideController@store');
            Route::get('/rides/estimate/{profile}', 'CarpoolRideController@getFareEstimate');
            Route::put('/rides/{ride}', 'CarpoolRideController@update');
        });

        Route::get('/profiles', 'CarpoolProfileController@index');
        Route::get('/profiles/{profile}', 'CarpoolProfileController@show');
    });
});
