<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCarpoolRidesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('carpool_rides', function (Blueprint $table) {
            $table->increments('id');
            $table->json('meta')->nullable();
            $table->string('address_from')->nullable();
            $table->decimal('longitude_from', 15, 7)->default(0.0);
            $table->decimal('latitude_from', 15, 7)->default(0.0);
            $table->string('address_to')->nullable();
            $table->decimal('longitude_to', 15, 7)->default(0.0);
            $table->decimal('latitude_to', 15, 7)->default(0.0);
            $table->dateTime('ride_on');
            $table->integer('seats')->default(0);
            $table->double('price')->default(0.0);
            $table->timestamps();

            $table->integer('user_id')->unsigned();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');

            $table->integer('profile_id')->unsigned();
            $table->foreign('profile_id')->references('id')->on('carpool_profiles')->onDelete('cascade');
        });

        Schema::create('carpool_riders', function (Blueprint $table) {
            $table->string('address_from')->nullable();
            $table->decimal('longitude_from', 15, 7)->default(0.0);
            $table->decimal('latitude_from', 15, 7)->default(0.0);
            $table->string('address_to')->nullable();
            $table->decimal('longitude_to', 15, 7)->default(0.0);
            $table->decimal('latitude_to', 15, 7)->default(0.0);
            $table->integer('seats');
            $table->double('price');
            $table->timestamps();

            $table->integer('user_id')->unsigned();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');

            $table->integer('ride_id')->unsigned();
            $table->foreign('ride_id')->references('id')->on('carpool_rides')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
    }
}
