<?php

namespace Vtlabs\Carpool\Models;

use EloquentFilter\Filterable;
use Vtlabs\Core\Models\User\User;
use Spatie\ModelStatus\HasStatuses;
use Vtlabs\Payment\Traits\CanBePaid;
use Illuminate\Database\Eloquent\Model;

class CarpoolRider extends Model
{
    use HasStatuses, Filterable, CanBePaid;

    protected $table = 'carpool_riders';

    protected $guarded = [];

    public static function boot()
    {
        parent::boot();

        // on create
        static::created(function ($order) {
            $order->setStatus(config('vtlabs_carpool.rider.status_default'));
        });
    }

    public function isValidStatus(string $name, ?string $reason = null): bool
    {
        return in_array($name, config('vtlabs_carpool.rider.status_list', []));
    }

    public function ride()
    {
        return $this->belongsTo(CarpoolRide::class, 'ride_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
