<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCarpoolRidesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('carpool_rides', function (Blueprint $table) {
            $table->increments('id');
            $table->json('meta')->nullable();
            $table->string('address_from');
            $table->decimal('longitude_from', 15, 7);
            $table->decimal('latitude_from', 15, 7);
            $table->string('address_to')->nullable();
            $table->decimal('longitude_to', 15, 7);
            $table->decimal('latitude_to', 15, 7);
            $table->dateTime('ride_on');
            $table->integer('seats');
            $table->integer('seats_confirmed')->defaul(0);
            $table->integer('seats_left')->defaul(0);
            $table->double('price_per_seat');
            $table->timestamps();

            $table->integer('profile_id')->unsigned();
            $table->foreign('profile_id')->references('id')->on('carpool_profiles')->onDelete('cascade');
        });

        Schema::create('carpool_riders', function (Blueprint $table) {
            $table->increments('id');
            $table->json('meta')->nullable();
            $table->string('address_from');
            $table->decimal('longitude_from', 15, 7);
            $table->decimal('latitude_from', 15, 7);
            $table->string('address_to')->nullable();
            $table->decimal('longitude_to', 15, 7);
            $table->decimal('latitude_to', 15, 7);
            $table->integer('seats');
            $table->double('price');
            $table->timestamps();

            $table->integer('user_id')->unsigned();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');

            $table->integer('ride_id')->unsigned();
            $table->foreign('ride_id')->references('id')->on('carpool_rides')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('carpool_rides', function (Blueprint $table) {
            $table->dropForeign(['user_id']);
            $table->dropForeign(['profile_id']);
        });

        Schema::dropIfExists('carpool_rides');
    }
}
