<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCarpoolPickupLocationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('carpool_pickup_locations', function (Blueprint $table) {
            $table->increments('id');
            $table->string('address', 500)->nullable();
            $table->decimal('longitude', 15, 7)->default(0.0);
            $table->decimal('latitude', 15, 7)->default(0.0);
            $table->enum('type', ['pickup', 'drop']);
            $table->time('time_start')->nullable();

            $table->timestamps();

            $table->integer('profile_id')->unsigned();
            $table->foreign('profile_id')->references('id')->on('carpool_profiles')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('carpool_pickup_locations', function (Blueprint $table) {
            $table->dropForeign(['profile_id']);
        });

        Schema::dropIfExists('carpool_pickup_locations');
    }
}
