<?php

namespace App\Http\Requests\Api\Customer;

use Illuminate\Foundation\Http\FormRequest;

class CarpoolProfileListRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'lat_from' => 'required|numeric',
            'long_from' => 'required|numeric',
            'lat_to' => 'required|numeric',
            'long_to' => 'required|numeric',
            'date' => 'required|date',
            'time' => 'required|date_format:H:i',
            'seats' => 'required|numeric'
        ];
    }
}
