<?php

namespace Vtlabs\Carpool\Models;

use DateTime;
use Carbon\Carbon;
use Illuminate\Http\Request;
use EloquentFilter\Filterable;
use Vtlabs\Core\Models\Setting;
use Vtlabs\Core\Models\User\User;
use Vtlabs\Payment\Traits\CanPay;
use Illuminate\Support\Facades\DB;
use Rennokki\Plans\Traits\HasPlans;
use Rennokki\Rating\Traits\CanBeRated;
use Illuminate\Database\Eloquent\Model;
use Rennokki\Rating\Contracts\Rateable;
use Vtlabs\Carpool\Models\PickupLocation;
use Vtlabs\Core\Traits\CoreHasMediaTrait;
use Spatie\MediaLibrary\HasMedia;
use ChristianKuri\LaravelFavorite\Traits\Favoriteable;

class CarpoolProfile extends Model implements HasMedia, Rateable
{
    use Filterable,
        Favoriteable,
        CoreHasMediaTrait,
        CanBeRated,
        HasPlans,
        CanPay;


    protected $table = 'carpool_profiles';

    protected $guarded = [];

    protected $casts = [
        'meta' => 'json',
        'vehicle_details' => 'json',
        'is_verified' => 'integer',
        'seats' => 'integer',
        'price' => 'float'
    ];

    public static function findByUser($userId)
    {
        return CarpoolProfile::where('user_id', $userId)->firstOrFail();
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function rides()
    {
        return $this->hasMany(CarpoolRide::class, 'profile_id');
    }

    public function locations()
    {
        return $this->hasMany(PickupLocation::class, 'profile_id');
    }
}
