<?php

namespace Vtlabs\Carpool\Http\Resources;

use Vtlabs\Core\Http\Resources\UserResource;
use Illuminate\Http\Resources\Json\JsonResource;
use Vtlabs\Payment\Http\Resources\PaymentResource;
use Vtlabs\Carpool\Http\Resources\CarpoolProfileResource as ResourcesCarpoolProfileResource;

class CarpoolRiderResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'meta' => $this->meta,
            'seats' => $this->seats,
            'address_from' => $this->address_from,
            'address_to' => $this->address_to,
            'price' => $this->price,
            'user_id' => $this->user_id,
            'user' => new UserResource($this->user),
            'ride_id' => $this->ride_id,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'status' => $this->status,
            'statuses' => $this->statuses,
            'payment' => new PaymentResource($this->payment),
        ];
    }
}
