<?php

namespace Vtlabs\Carpool\Http\Resources;

use Vtlabs\Core\Http\Resources\UserResource;
use Illuminate\Http\Resources\Json\JsonResource;
use Vtlabs\Payment\Http\Resources\PaymentResource;
use Vtlabs\Carpool\Http\Resources\CarpoolProfileResource as ResourcesCarpoolProfileResource;

class CarpoolRideResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'meta' => $this->meta,
            'address_from' => $this->address_from,
            'longitude_from' => $this->longitude_from,
            'latitude_from' => $this->latitude_from,
            'address_to' => $this->address_to,
            'longitude_to' => $this->longitude_to,
            'latitude_to' => $this->latitude_to,
            'ride_on' => $this->ride_on,
            'seats' => $this->seats,
            'seats_confirmed' => $this->seats_confirmed,
            'seats_left' => $this->seats_left,
            'price_per_seat' => $this->price_per_seat,
            'profile_id' => $this->profile_id,
            'profile' => new ResourcesCarpoolProfileResource($this->profile),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'status' => $this->status,
            'statuses' => $this->statuses,
            'riders' => CarpoolRiderResource::collection($this->riders)
        ];
    }
}
