<?php

namespace Vtlabs\Carpool\Http\Controllers\Api\Admin;

use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Gate;
use Vtlabs\Carpool\Models\CarpoolRide;
use Vtlabs\Core\Http\Controllers\Controller;
use Vtlabs\Carpool\Filters\CarpoolRideFilter;
use Vtlabs\Carpool\Http\Resources\Admin\CarpoolRideAdminResource;

class CarpoolRideController extends Controller
{
    public function index(Request $request)
    {
        $rides = CarpoolRide::filter($request->all(), CarpoolRideFilter::class)->latest();

        return CarpoolRideAdminResource::collection($rides->paginate());
    }

    public function show(CarpoolRide $ride)
    {
        return new CarpoolRideAdminResource($ride);
    }

    public function update(CarpoolRide $ride, Request $request)
    {
        $request->validate([
            'status' => ['required', Rule::in(config('vtlabs_carpool.ride.status_list', []))]
        ]);

        if ($ride->status !== $request->status) {
            $lastStatus = $ride->status;

            $ride->setStatus($request->status);

            $ride->save();

            //event(new UpdateOrderStatus($order, 'order', $request->status, $lastStatus));
        }

        return new CarpoolRideAdminResource($ride->fresh());
    }

    public function destroy(CarpoolRide $ride, Request $request)
    {
        Gate::authorize('delete');

        $ride->delete();

        return response()->json([], 200);
    }
}
