<?php

namespace Vtlabs\Carpool\Filters;

use Carbon\Carbon;
use EloquentFilter\ModelFilter;
use Illuminate\Support\Facades\Auth;
use Vtlabs\Carpool\Models\CarpoolRider;
use Vtlabs\Carpool\Models\CarpoolProfile;

class CarpoolRideFilter extends ModelFilter
{
    public function setup()
    {
    }

    public function status($status)
    {
        return $this->currentStatus($status);
    }

    public function rideon($rideon)
    {
        return $this->whereDate('ride_on', '=', Carbon::createFromFormat("Y-m-d H:i", $rideon)->toDateString())
                ->whereTime('ride_on', '<=', Carbon::createFromFormat("Y-m-d H:i", $rideon)->addMinutes(30)->toTimeString())
                ->whereTime('ride_on', '>=', Carbon::createFromFormat("Y-m-d H:i", $rideon)->subMinutes(30)->toTimeString());
    }

    public function seats($seats)
    {
        return $this->where('seats_left', '>=', $seats);
    }

    public function profile($profileId)
    {
        return $this->where('profile_id', $profileId);
    }

    public function user($userId)
    {
        return $this->where('user_id', $userId);
    }

    public function myofferings($myofferings)
    {
        $profile = CarpoolProfile::findByUser(Auth::id());
        return $this->where('profile_id', $profile->id);
    }

    public function myfindings($myfindings)
    {
        return $this->whereIn('id', CarpoolRider::where('user_id', Auth::id())->distinct('ride_id')->pluck('ride_id')->toArray());
    }
}
