<?php

namespace Vtlabs\Cardgame\Providers;

use Vtlabs\Core\Events\LoggedIn;
use Vtlabs\Core\Events\RoleAssigned;
use Vtlabs\Payment\Events\PaymentUpdated;
use Vtlabs\Payment\Events\OnWalletPayment;
use Vtlabs\Cardgame\Listeners\LoggedInListener;
use Vtlabs\Cardgame\Listeners\RoleAssignedListener;
use Vtlabs\Cardgame\Listeners\PaymentUpdatedListener;
use Vtlabs\Cardgame\Listeners\OnWalletPaymentListener;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        LoggedIn::class => [LoggedInListener::class],
        RoleAssigned::class => [RoleAssignedListener::class],
        OnWalletPayment::class => [OnWalletPaymentListener::class],
        PaymentUpdated::class => [PaymentUpdatedListener::class],
    ];

    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot()
    {
        parent::boot();

        //
    }
}
