<?php

namespace Vtlabs\Cardgame\Models;

use EloquentFilter\Filterable;
use Vtlabs\Cardgame\Models\Product;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

enum RewardType: string {
    case Chip = 'chip';
    case Frame = 'frame';
}

class Reward extends Model
{
    use Filterable;

    protected $table = 'cardgame_rewards';

    protected $guarded = [];

    protected $casts = [
        'meta' => 'json',
        'type' => RewardType::class
    ];

    public function rewardable(): MorphTo
    {
        return $this->morphTo();
    }

    public function product(): BelongsTo
    {
        return $this->belongsTo(Product::class);
    }
}
