<?php

namespace Vtlabs\Cardgame\Models;

use EloquentFilter\Filterable;
use Vtlabs\Core\Traits\HasUser;
use Illuminate\Support\Facades\DB;
use Vtlabs\Core\Helpers\CoreHelper;
use Illuminate\Database\Eloquent\Model;

class Profile extends Model
{
    use Filterable,
        HasUser;

    protected $table = 'cardgame_profiles';

    protected $guarded = [];

    protected $casts = [
        'meta' => 'json'
    ];

    protected $with = ['user'];

    public static function boot()
    {
        parent::boot();

        // on create
        static::created(function ($user) {

            // create a unique code for the profile
            while (1) {
                $code = CoreHelper::generateRandomString();
                if (!Profile::where('profilecode', $code)->exists()) {
                    $user->profilecode = $code;
                    $user->save();
                    break;
                }
            }
        });
    }

    public function level()
    {
        return $this->belongsTo(Level::class);
    }

    public static function leaderboard($limit = 100)
    {
        return DB::select('SELECT p.id as profile_id, p.user_id, p.balance, FIND_IN_SET( balance, (SELECT GROUP_CONCAT( DISTINCT balance ORDER BY balance DESC ) FROM cardgame_profiles) ) AS leaderboard_rank FROM cardgame_profiles p left join users u on p.user_id=u.id order by leaderboard_rank limit ?;', [$limit]);
    }
}
