<?php

namespace Vtlabs\Cardgame\Models;

use EloquentFilter\Filterable;
use Spatie\MediaLibrary\HasMedia;
use Vtlabs\Cardgame\Models\Level;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use Vtlabs\Core\Traits\CoreHasMediaTrait;

enum ProductType: string {
    case Chip = 'chip';
    case Frame = 'frame';
}

enum ProductCurrencyType: string {
    case Real = 'real';
    case Chip = 'chip';
}

class Product extends Model implements HasMedia
{
    use Filterable, CoreHasMediaTrait, HasTranslations;

    protected $table = 'cardgame_products';

    protected $guarded = [];

    protected $casts = [
        'title' => 'array',
        'details' => 'array',
        'meta' => 'json',
        'type' => ProductType::class,
        'currency_type' => ProductCurrencyType::class,
        'quantity' => 'integer',
        'price' => 'float',
        'charges' => 'float',
        'taxes' => 'float'
    ];

    public $translatable = ['title', 'details'];

    public function scopeOrdered($query)
    {
        return $query->orderBy('price');
    }
}
