<?php

namespace Vtlabs\Cardgame\Models;

use EloquentFilter\Filterable;
use Vtlabs\Cardgame\Models\Poker;
use Vtlabs\Cardgame\Models\Profile;
use Illuminate\Database\Eloquent\Model;

class Pokerplayer extends Model
{
    use Filterable;

    protected $table = 'cardgame_pokerplayers';

    protected $guarded = [];

    protected $with = ['profile'];

    protected $casts = [
        'meta' => 'json',
        'joining_balance' => 'float',
        'used_balance' => 'float',
        'turn_amount' => 'float',
        'position' => 'integer',
        'turn_count' => 'integer'
    ];

    public function profile()
    {
        return $this->belongsTo(Profile::class);
    }

    public function game()
    {
        return $this->belongsTo(Poker::class);
    }
}
