<?php

namespace Vtlabs\Cardgame\Models;

use EloquentFilter\Filterable;
use Vtlabs\Core\Models\User\User;
use Spatie\ModelStatus\HasStatuses;
use Vtlabs\Cardgame\Models\Product;
use Vtlabs\Payment\Traits\CanBePaid;
use Vtlabs\Payment\Contracts\Payable;
use Illuminate\Database\Eloquent\Model;

class Order extends Model implements Payable
{
    use CanBePaid, Filterable, HasStatuses;
    
    protected $table = 'cardgame_orders';

    protected $guarded = [];

    protected $casts = [
        'meta' => 'array',
        'subtotal' => 'float',
        'taxes' => 'float',
        'total' => 'float',
        'discount' => 'float',
    ];

    protected $with =  ['user', 'product', 'payment'];

    public static function boot()
    {
        parent::boot();

        // on create
        static::created(function ($order) {
            $order->setStatus(config('vtlabs_cardgame.order.status_default'));
        });
    }

    public function isValidStatus(string $name, ?string $reason = null): bool
    {
        return in_array($name, config('vtlabs_cardgame.order.status_list', []));
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }
}
