<?php

namespace Vtlabs\Cardgame\Models;

use EloquentFilter\Filterable;
use Spatie\MediaLibrary\HasMedia;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use Vtlabs\Core\Traits\CoreHasMediaTrait;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphMany;

enum LevelConditionType: string {
    case Chip = 'chip';
}

class Level extends Model implements HasMedia
{
    use Filterable, CoreHasMediaTrait, HasTranslations;

    protected $table = 'cardgame_levels';

    protected $guarded = [];

    protected $casts = [
        'title' => 'array',
        'meta' => 'json',
        'condition_type' => LevelConditionType::class,
        'condition_count' => 'integer',
        'sort_order' => 'integer'
    ];

    public $translatable = ['title'];

    public function scopeOrdered($query)
    {
        return $query->orderBy('sort_order');
    }

    public function parent(): BelongsTo
    {
        return $this->belongsTo(Level::class, 'parent_id');
    }

    public function rewards(): MorphMany
    {
        return $this->morphMany(Reward::class, 'rewardable');
    }
}
