<?php

namespace Vtlabs\Cardgame\Models;

use EloquentFilter\Filterable;
use Vtlabs\Cardgame\Models\Game;
use Vtlabs\Cardgame\Models\Profile;
use Illuminate\Database\Eloquent\Model;

class Gameplayer extends Model
{
    use Filterable;

    protected $table = 'cardgame_gameplayers';

    protected $guarded = [];

    protected $with = ['profile'];

    protected $casts = [
        'meta' => 'json',
        'position' => 'integer',
        'points' => 'integer',
        'turn_count' => 'integer',
        'is_card_picked' => 'integer'
    ];

    public function profile()
    {
        return $this->belongsTo(Profile::class);
    }

    public function game()
    {
        return $this->belongsTo(Game::class);
    }
}
