<?php

namespace Vtlabs\Cardgame\Models;

use EloquentFilter\Filterable;
use Vtlabs\Cardgame\Models\Product;
use Illuminate\Database\Eloquent\Model;
use Spatie\Translatable\HasTranslations;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphMany;

enum ChallengeType: string {
    case Daily = 'daily';
    case Others = 'others';
}

enum ActionType: string {
    case Watch = 'watch';
    case Play = 'play';
}

class Challenge extends Model
{
    use Filterable, HasTranslations;

    protected $table = 'cardgame_challenges';

    protected $guarded = [];

    protected $casts = [
        'title' => 'array',
        'details' => 'array',
        'meta' => 'json',
        'type' => ChallengeType::class,
        'action' => ActionType::class,
        'tasks_count' => 'integer',
        'sort_order' => 'integer'
    ];

    public $translatable = ['title', 'details'];

    public function scopeOrdered($query)
    {
        return $query->orderBy('sort_order');
    }

    public function rewards(): MorphMany
    {
        return $this->morphMany(Reward::class, 'rewardable');
    }
}
