<?php

namespace Vtlabs\Cardgame\Models;

use EloquentFilter\Filterable;
use Illuminate\Database\Eloquent\Model;
use Spatie\MediaLibrary\HasMedia;
use Vtlabs\Core\Traits\CoreHasMediaTrait;

class Cashtable extends Model
{
    use Filterable, CoreHasMediaTrait;

    protected $table = 'cardgame_cashtable';

    protected $guarded = [];

    protected $casts = [
        'meta' => 'json',
        'reward' => 'float',
        'amount' => 'float',
        'online_count' => 'integer'
    ];

    public function scopeOrdered($query)
    {
        return $query->orderBy('amount');
    }
}
