<?php

namespace Vtlabs\Cardgame\Models;

use EloquentFilter\Filterable;
use Illuminate\Database\Eloquent\Model;
use Spatie\MediaLibrary\HasMedia;
use Vtlabs\Core\Traits\CoreHasMediaTrait;

class Avatar extends Model implements HasMedia
{
    use Filterable, CoreHasMediaTrait;

    protected $table = 'cardgame_avatars';

    protected $guarded = [];

    protected $casts = [
        'meta' => 'json',
        'sort_order' => 'integer'
    ];

    protected $with = ['media'];

    public function scopeOrdered($query)
    {
        return $query->orderBy('sort_order');
    }
}
