<?php

namespace Vtlabs\Cardgame\Listeners;

use Vtlabs\Cardgame\Models\Profile;
use Vtlabs\Core\Events\RoleAssigned;

class RoleAssignedListener
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  RoleAssigned $event
     * @return void
     */
    public function handle(RoleAssigned $event)
    {
        if (in_array('customer', $event->roles)) {
            if (!Profile::where('user_id', $event->user->id)->exists()) {
                Profile::create([
                    'user_id' => $event->user->id
                ]);
            }
        }

        return true;
    }
}
