<?php

namespace Vtlabs\Cardgame\Listeners;

use Vtlabs\Cardgame\Models\Order;
use Vtlabs\Core\Models\User\User;
use Vtlabs\Cardgame\Models\Product;
use Vtlabs\Cardgame\Models\ProductType;
use Vtlabs\Payment\Events\PaymentUpdated;

class PaymentUpdatedListener
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  Registered $event
     * @return void
     */
    public function handle(PaymentUpdated $event)
    {
        $payment = $event->payment;

        // we need to process the order according to payment status
        if ($payment->payable_type == 'Vtlabs\Cardgame\Models\Order') {
            if ($payment->status == 'paid') {
                $order = Order::find($payment->payable_id);
                $order->setStatus('complete');
                $order->save();

                if($order->product->type == ProductType::Chip) {
                    $order->user->deposit($order->product->quantity, 'deposit', [
                        'description' => 'Bought Chips',
                        'type' => 'purchase_chips'
                    ]);
                }
            }

            if ($payment->status == 'failed') {
                $order = Order::find($payment->payable_id);
                $order->setStatus('cancelled');
                $order->save();
            }
        }

        return true;
    }
}
