<?php

namespace Vtlabs\Cardgame\Listeners;

use Vtlabs\Core\Models\User\User;
use Vtlabs\Cardgame\Models\Order;
use Vtlabs\Payment\Events\OnWalletPayment;

class OnWalletPaymentListener
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  OnWalletPayment $event
     * @return void
     */
    public function handle(OnWalletPayment $event)
    {
        $payment = $event->payment;

        if ($payment->payable_type == Order::class && $payment->status == 'paid') {
            $order = Order::find($payment->payable_id);

            if ($payment->user_id) {
                $user = User::find($payment->payer_id);

                $user->withdraw($payment->amount, 'withdraw', [
                    'description' => 'Bought ' . $order->product->title,
                    'type' => 'purchase_product'
                ]);
            }
        }
    }
}
