<?php

namespace Vtlabs\Cardgame\Jobs;

use Illuminate\Support\Arr;
use Illuminate\Support\Str;
use Illuminate\Bus\Queueable;
use Vtlabs\Cardgame\Models\Game;
use Vtlabs\Cardgame\Jobs\AutoTurn;
use Vtlabs\Core\Helpers\CoreHelper;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Vtlabs\Core\Services\FirebaseService;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;

class TurnSetup implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    private $gameId;

    public function __construct($gameId)
    {
        $this->gameId = $gameId;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        try {
            $game = Game::find($this->gameId);
            $game->status = 'turn_setup';
            $game->player_turn = 1;
            $game->next_turn_uuid = Str::uuid();

            $game->save();

            $game = $game->fresh();

            $firebaseDatabase = FirebaseService::getDatabaseInstance();
            if ($firebaseDatabase) {
                $firebaseDatabase->getReference('/fire_app/games/' . $game->id)->set($game);
            }

            // run next job which will do the turn setup
            $settings = CoreHelper::settingsAsDictionary();
            AutoTurn::dispatch($game->id, $game->player_turn, $game->next_turn_uuid)->delay(now()->addSeconds($settings['turn_interval_in_seconds']));
            
        } catch (\Exception $ex) {
            //
        }
    }
}
