<?php

namespace Vtlabs\Cardgame\Jobs;

use Illuminate\Bus\Queueable;
use Vtlabs\Cardgame\Models\Game;
use Vtlabs\Core\Helpers\CoreHelper;
use Vtlabs\Cardgame\Jobs\PlayerSetup;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Vtlabs\Core\Services\FirebaseService;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;

class StartGame implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    private $gameId;

    public function __construct($gameId)
    {
        $this->gameId = $gameId;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        try {
            $game = Game::find($this->gameId);
            $game->status = 'toss_unassigned';
            
            $posArray = range(1, $game->gamePlayers()->count());
            shuffle($posArray);
            
            foreach ($game->gamePlayers as $index => $gamePlayer) {
                $gamePlayer->position = $posArray[$index];
                $gamePlayer->save();
            }
            $game->save();

            $game = $game->fresh();

            $firebaseDatabase = FirebaseService::getDatabaseInstance();
            if ($firebaseDatabase) {
                $firebaseDatabase->getReference('/fire_app/games/' . $game->id)->set($game);
            }

            // run next job which will do the setup of game
            $settings = CoreHelper::settingsAsDictionary();
            PlayerSetup::dispatch($game->id)->delay(now()->addSeconds($settings['player_setup_in_seconds']));
        } catch (\Exception $ex) {
            //
        }
    }
}
